package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public abstract class RankComponentAction implements BaseComponentAction {
    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.RANK;
    }

    /**
     * 查询排行榜信息
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryRankInfo", desc = "查询排行榜信息")
    public abstract RankConfigVo queryRankInfo(UserRequestApi api);

    /**
     * 查询排行榜
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryRanking", desc = "查询排行榜")
    public abstract RankingVo queryRanking(UserRequestApi api);


    /**
     * 查询当前用户排行榜信息
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryUserRanking", desc = "查询当前用户排行榜信息")
    public abstract RankingVo.RankingInfo  queryUserRanking(UserRequestApi api);


    /**
     * 查询当前排行榜是否最后一期
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryLastPhaseAction", desc = "查询当前排行榜是否最后一期")
    public abstract Boolean queryLastPhaseAction(UserRequestApi api);


    /**
     * 查询中奖信息
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryPrizeAction", desc = "查询中奖信息")
    public abstract RankPeriodPrizeVo queryPrizeAction(UserRequestApi api);
}
