package cn.com.duiba.galaxy.sdk.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 访客校验，如果用户uid为not_login,则被拦截
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface VisitorCheck {

    /**
     * 访客校验，如果用户uid为not_login,则被拦截,可以添加自定义的访客用户id
     * @return 访客用户id
     */
    String[] value() default {"not_login"};
}
