package cn.com.duiba.galaxy.sdk.api.credits;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.api.credits.inner.CreditsRecord;
import cn.com.duiba.galaxy.sdk.api.credits.inner.DeductCreditsRequest;

import java.util.Date;
import java.util.List;


/**
 * 积分操作api
 *
 * @author fangxiaorun
 * @date 2023/01/09
 */
public interface CreditsApi extends AutowiredApi {

    /**
     * 回退当前用户针对某个玩法某个动作扣积分未使用的积分票据【需要则在首页接口触发，不需要则不触发】
     *
     * @param playwayId    扣积分的玩法id（必传）
     * @param actionId     扣积分的动作id（必传）
     * @param startTime    开始时间，创建时间大于等于这个时间（可以传null，表示不限定创建时间下限）
     * @param endTime      结束时间，创建时间小于等于这个时间 （传null 或 传的值大于当前时间1分钟前，则会取当前时间1分钟前）
     * @param maxDealCount 最多处理几个（必传，最大传5，超过会取5，单次不要处理太多个，可能会导致接口超时，建议单次处理1个）
     * @param desc         回退积分描述（必传）
     * @param transfer     transfer参数（不需要指定则传null，会取context里面的transfer值）
     */
    void returnCurrentUserUnusedTickets(String playwayId, String actionId, Date startTime, Date endTime, int maxDealCount, String desc, String transfer);

    /**
     * 发起扣积分，返回扣积分门票
     *
     * @param request 请求
     * @return {@link String}
     */
    String deductCredits(DeductCreditsRequest request);

    /**
     * 扣积分门票是否可用
     *
     * @param userId    用户id
     * @param ticketNum 门票
     * @param credits   积分
     * @return boolean
     */
    boolean isCreditsTicketUsable(Long userId, String ticketNum, Long credits);

    /**
     * 使用扣积分门票
     *
     * @param userId    用户id
     * @param ticketNum 门票
     * @return {@link Boolean}
     */
    Boolean useCreditsTicket(Long userId, String ticketNum);

    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 门票
     * @return {@link CreditsRecord}
     */
    CreditsRecord getCreditsTicket(String ticketNum);

    /**
     * 获取当前用户对应玩法动作下对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param userId   用户id
     * @param quantity 数量
     * @return {@link List}<{@link CreditsRecord}>
     */
    List<CreditsRecord> findUnusedTicketList(Long userId, Long quantity);



    /**
     * 获取当前用户对应玩法动作下,某段时间生成的对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param playwayId 玩法id(选填)
     * @param actionId  actionId(选填)
     * @param quantity  积分数量(选填)
     * @param startTime 开始时间(选填) （startTime<=gmt_create）
     * @param endTime   结束时间(选填)  (endTime>=gmt_create)
     * @return
     */
    List<CreditsRecord> findUnusedTicketList(String playwayId, String actionId, Long quantity, Date startTime, Date endTime);
}
