package cn.com.duiba.galaxy.sdk.api.tools.inner.logger;


import java.util.Map;

/**
 * 埋点服务
 */
public interface BuriedPointService {

    /**
     * 添加埋点信息
     *
     * 同线程中，多次调用put相同事件，会将非NULL的值进行覆盖和补充
     *
     * @see BuriedPointInfoEnum.EventType#builder(Object...)
     */
    void put(Map<String, Object> eventType);


    /**
     * 直接打埋点，适用于非http请求线程
     * @param eventType
     */
    void print(Long appId, Long projectId, Long userId, Map<String, Object> eventType);
}
