package cn.com.duiba.galaxy.sdk.component.answer;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.Token;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerCompletedResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerQuestionResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerStartResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerSubmitResult;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhangdaqing
 * @Date 2023/3/13 15:33
 **/
public class AnswerComponentActionDefault extends AnswerComponentAction {

    private final String componentId;

    public AnswerComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.ANSWER;
    }

    @Override
    @UserConcurrentLock
    @CustomRequestAction(id = "getQuestion", desc = "获取题目")
    public AnswerQuestionResult getQuestion(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId不能为空", false);
        }
        return api.getComponentApi().getAnswerApi().getQuestion(componentId, startId);
    }

    @Override
    @UserConcurrentLock
    @CustomRequestAction(id = "start", desc = "开始答题")
    public AnswerStartResult start(UserRequestApi api) {
        return api.getComponentApi().getAnswerApi().start(componentId, null);
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id = "submit", desc = "提交答案")
    public AnswerSubmitResult submit(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId不能为空", false);
        }
        String answer = api.getStringParameter("answer");
        if (StringUtils.isBlank(answer)) {
            throw new BizRuntimeException("answer不能为空", false);
        }
        return api.getComponentApi().getAnswerApi().submit(componentId, startId, answer, null);
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id = "doCompleted", desc = "完成答题")
    public AnswerCompletedResult doCompleted(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId不能为空", false);
        }
        return api.getComponentApi().getAnswerApi().completed(componentId, startId);
    }
}
