package cn.com.duiba.galaxy.sdk.component.exchange;


import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;
import cn.com.duiba.galaxy.sdk.component.task.TaskItemConfig;
import cn.com.duiba.galaxy.sdk.component.task.TaskQueryResult;
import cn.com.duiba.galaxy.sdk.component.task.TaskResult;

import java.util.Date;
import java.util.Map;

public interface ExchangeApi extends UserRequestApi {


    /**
     * 兑换列表
     * @param componentId
     * @return
     */
    ExchangeListResult exchangeList(String componentId);

    /**
     * 兑换权限
     * @param componentId
     * @param sign
     * @return
     */
    ExchangeLimitEnum exchangeAuth(String componentId,String sign);

    /**
     * 执行兑换
     * @param componentId
     * @param sign
     * @return
     */
    ExchangeResult doExchange(String componentId,String sign);



    /**
     * 扣积分
     * @param componentId
     * @param sign
     * @return
     */
    String deductCredits(String componentId,String sign);


    /**
     * 查询扣积分状态
     *
     * @param ticket 票
     * @return {@link Integer}
     */
    Integer queryDeductCreditsStatus(String ticket);

}
