package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.sdk.api.prize.inner.Option;
import cn.com.duiba.galaxy.sdk.component.drawprize.enums.OtherJoinTypeEnum;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 刘佳辉
 * @since 2023/5/23
 */
@Data
public class ExchangeListResult {

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;


    /**
     * 兑换配置
     */
    @NotNull
    private List<ExchangeConditionsConfig> conditions;


    @Data
    public static class ExchangeConditionsConfig {

        /**
         * 兑换标识 p1 p2 ..
         */
        private String sign;

        /**
         * 所需消耗的信息
         */
        private List<ExchangeConsumeConfig> consumeResources;
        /**
         * 奖品配置信息
         */
        private OptionJsonParam option;


        /**
         * 奖品限制类型
         * 0=不限制
         * 1=日
         * 2=周
         * 3=月
         * 4=永久
         */
        @NotNull
        private Integer intervalType;


        /**
         * 奖品限制值
         */
        private Integer intervalLimitSize;


        /**
         * 用户限制类型
         * 0=不限制
         * 1=日
         * 2=周
         * 3=月
         * 4=永久
         */
        @NotNull
        private Integer userIntervalType;


        /**
         * 用户限制值
         */
        private Integer userIntervalLimitSize;


        /**
         * 排序
         */
        private Integer pos;


        /**
         * 限制：ExchangeLimitEnum
         */
        private Integer limit;

    }

    @Data
    public static class ExchangeConsumeConfig {

        /**
         * 类型
         */
        private OtherJoinTypeEnum joinTypeEnum;

        /**
         * 数量
         */
        private Long joinNum;


    }


    @Data
    public class OptionJsonParam implements Serializable {

        private static final long serialVersionUID = -1458429323665526349L;


        /**
         * 奖项id
         */
        private Long id;
        /**
         * 奖项名称
         */
        private String name;
        /**
         * 奖项类型
         */
        private Integer type;
        /**
         * 商品id
         */
        private String itemId;
        /**
         * 图标
         */
        private String icon;

        /**
         * 图标
         */
        private String icon2;


        /**
         * 总库存
         */
        private Long totalStock;

        /**
         * 概率
         */
        private String rate;
        /**
         * 用户中奖限制次数
         */
        private Long userLimit;

        /**
         * 用户中奖限制类型(日，周，月，永久)
         */
        private Integer userLimitType;

        /**
         * 发奖限制
         */
        private Long awardLimit;
        /**
         * 发奖限制类型(日，周，月，永久)
         */
        private Integer awardLimitType;

        /**
         * 奖品id
         */
        private Long prizeId;

        /**
         * 奖项位置
         */
        private Integer pos;

        /**
         * 已使用库存
         */
        private Long usedStock;

        /**
         * 保底次数(针对用户维度，产生多少次抽奖行为才会中奖)
         */
        private Long atleastTimes;

        /**
         * 是否在首页展示 0 不展示 ， 1展示
         */
        private Integer showIndexType;

        /**
         * 单次发放个数(仅道具)
         */
        private Long sendCount;

        /**
         * 是否允许多奖项
         */
        private boolean multipleOption;


        /**
         * 商品来源
         */
        private Integer bizType;

        /**
         * 商品类型
         */
        private Integer itemType;

        /**
         * 挡位
         */
        private String degree;

    }

}
