package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.UserRequestApi;

import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public interface RankApi extends UserRequestApi {


    /**
     * 更新排行榜分数通过增加
     * 更新排行榜分数(在原来的分数基础上递增)
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @param score           分数
     * @throws BizRuntimeException 业务运行时异常
     */
    void updateRankingScoreByIncr(String rankComponentId, Long userId, int score) throws BizRuntimeException;

    /**
     * 更新排行榜分数
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @param score           分数
     * @throws BizRuntimeException 业务运行时异常
     */
    void updateRankingScore(String rankComponentId, Long userId, int score) throws BizRuntimeException;


    /**
     * 获取某个人当前排行榜名次
     *
     * @param userId          用户id
     * @param rankComponentId 排行榜组件id
     * @return {@link Integer}
     */
    Integer getCurrentRanking(String rankComponentId, Long userId);


    /**
     * 指定期次的排名
     * @param rankComponentId
     * @param userId
     * @param type
     * @return
     */
    Integer getRanking(String rankComponentId, Long userId,String type);


    /**
     * 获取某人以前排行榜名次
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Integer}
     */
    Integer getPreviousRanking(String rankComponentId, Long userId);

    /**
     * 获取当前绑单前n名的排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param topN            topn
     * @return {@link List}<{@link Ranking}>
     */
    List<Ranking> getCurrentTopN(String rankComponentId, int topN);



    List<Ranking> getRankingTopN(String rankComponentId,String type, int topN);


    /**
     * 获取上一期排行榜
     *
     * @param rankComponentId 排行榜组件id
     * @param topN            topn
     * @return {@link List}<{@link Ranking}>
     */
    List<Ranking> getPreviousTopN(String rankComponentId, int topN);

    /**
     * 获取排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Ranking}
     */
    Ranking getCurrentRankInfo(String rankComponentId, Long userId);

    /**
     * 获取以前排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Ranking}
     */
    Ranking getPreviousRankInfo(String rankComponentId, Long userId);


    /**
     * 获取历史排行榜信息
     * @param rankComponentId
     * @param userId
     * @param type
     * @return
     */
    Ranking getHistoryRankInfo(String rankComponentId, Long userId,String type);


    /**
     * 上一期排行榜类型
     * @param rankComponentId
     * @return
     */
    String getPreviousType(String rankComponentId);


    /**
     * 获得历史期次类型
     * @param rankComponentId
     * @param lastIndex 0 当前期次 1倒数第一期 2倒数第二期 ...
     * @return
     */
    String getHistoryType(String rankComponentId,Integer lastIndex);

    /**
     * 当期排行榜类型
     * @param rankComponentId
     * @return
     */
    String getCurrentType(String rankComponentId);



    RankConfigVo queryArchive(String rankComponentId,String type);

    /**
     * 查询当期排行榜期次
     * @param rankComponentId
     * @return
     */
    RankConfigVo queryArchive(String rankComponentId);


    /**
     * 查询上一期排行榜期次
     * @param rankComponentId
     * @return
     */
    RankConfigVo queryPreviousArchive(String rankComponentId);


    /**
     * 查询是否是最后一期
     * @param rankComponentId
     * @return
     */
    boolean queryLastPhaseAction(String rankComponentId,String type);



    boolean queryLastPhaseAction(String rankComponentId);

    /**
     * 查询指定期次的用户中奖信息
     * @param componentId
     * @param type
     * @return
     */
    RankPeriodPrizeVo queryPrizeAction(String componentId, String type);

    /**
     * 判断排行榜是否开启
     * @param componentCode
     * @return
     */
    boolean getEnable(String componentCode);
}
