package cn.com.duiba.galaxy.sdk.component.rank;

import lombok.Data;

import java.util.Date;

/**
 * @author 刘佳辉
 * @since 2023/2/20
 */
@Data
public class RankPeriodPrizeVo {

    /**
     * 排行榜期次
     */
    private String rankingType;

    /**
     * 期次开始时间
     */
    private Date startTime;

    /**
     * 期次结束时间
     */
    private Date endTime;

    /**
     * 开奖时间
     */
    private Date opTime;

    /**
     * 中的奖品
     * <p>
     * 未上榜的用户，奖品为空
     */
    private RankLeaderBoardPrize prize;


    @Data
    public static class RankLeaderBoardPrize {
        /**
         * 奖品名
         */
        private String optionName;

        /**
         * 奖项类型：1-采购奖品，2-道具，3-谢谢参与
         */
        private Integer optionType;

        /**
         * 已获得奖项图片
         */
        private String optionImg1;

        /**
         * 未获得奖项图片
         */
        private String optionImg2;

        /**
         * 奖品ID：奖品ID：prize表中的主键id
         */
        private Long prizeId;

        /**
         * 奖品链接
         * <p>
         * 如果发奖失败，链接为空
         */
        private String url;

        /**
         * 用户中奖记录id
         * <p>
         * 如果发奖失败，记录为空
         */
        private Long userPrizeRecordId;

    }
}
