package cn.com.duiba.galaxy.sdk.message;


import cn.com.duiba.galaxy.common.message.BizError;
import cn.com.duiba.galaxy.common.message.SystemModuleEnum;
import cn.com.duiba.galaxy.common.message.TmpDescBizError;
import org.apache.commons.lang3.StringUtils;

/**
 * 通用、默认状态码
 * 1、作为BizError接口使用演示Demo；
 *
 * @author fangxiaorun
 * @date 2022/09/28
 */
public enum UnclassifiedStatusEnum implements BizError {
    /**
     * 系统错误
     */
    SYSTEM_ERROR("1001", "网络繁忙，请稍后重试！"),
    /**
     * 参数错误
     */
    PARAM_ERROR("1002", "参数错误"),

    /**
     * 获取不到锁
     */
    LOCK_FAILD("1003", "访问过于频繁，请稍后重试！"),


    ;
    /**
     * 自定义编码
     */
    private final String nodeCode;

    /**
     * 描述
     */
    private  String desc;

    UnclassifiedStatusEnum(String nodeCode, String desc) {
        this.nodeCode = nodeCode;
        this.desc = desc;
    }

    /**
     * 获取场景类型
     *
     * @return {@link SystemModuleEnum}
     */
    @Override
    public SystemModuleEnum getBizScene() {
        return SystemModuleEnum.UNCLASSIFIED;
    }

    /**
     * 获取自定义编码（获取完整编码通过方法{@link BizError#getCode()}获取）
     *
     * @return {@link String}
     */
    @Override
    public String getNodeCode() {
        return nodeCode;
    }

    /**
     * 获取描述信息
     *
     * @return {@link String}
     */
    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * 对指定错误类型修改描述
     *
     * @return {@link UnclassifiedStatusEnum}
     */
    public BizError setDesc(String errorMsg) {
        if (StringUtils.isNotEmpty(errorMsg)) {
            BizError tmpError = new TmpDescBizError(this,errorMsg);
            return tmpError;
        }
        return this;
    }
}