/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component;

import cn.com.duiba.wolf.utils.DateUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public enum TimeUnitEnum {
    NO_LIMIT(0, "\u4e0d\u9650\u5236"),
    DAY(1, "\u65e5"),
    WEEK(2, "\u5468"),
    MONTH(3, "\u6708"),
    FOREVER(4, "\u6c38\u4e45"),
    CUSTOM(5, "\u81ea\u5b9a\u4e49");

    private int type;
    private String desc;

    private TimeUnitEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static TimeUnitEnum toEnum(int type) {
        for (TimeUnitEnum p : TimeUnitEnum.values()) {
            if (p.type != type) continue;
            return p;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public Long getNowToEndTime() {
        Date now = new Date();
        if (this == DAY) {
            return DateUtils.getDayEndTime((Date)now).getTime() - now.getTime();
        }
        if (this == WEEK) {
            return TimeUnitEnum.getWeekLastDay(now).getTime() - now.getTime();
        }
        if (this == MONTH) {
            return TimeUnitEnum.getMonthLastDay(now).getTime() - now.getTime();
        }
        if (this == FOREVER) {
            return DateUtils.daysAddOrSub((Date)now, (int)2190).getTime() - now.getTime();
        }
        return null;
    }

    public String geStartTime() {
        LocalDate now = LocalDate.now();
        if (this == DAY) {
            return now.toString();
        }
        if (this == WEEK) {
            return now.minusDays(now.getDayOfWeek().getValue() - 1).toString();
        }
        if (this == MONTH) {
            return now.withDayOfMonth(1).toString();
        }
        if (this == FOREVER) {
            return "";
        }
        return null;
    }

    public List<TimeUnitEnum> geOtherTimeUnit() {
        ArrayList<TimeUnitEnum> effectiveTimeUnit = new ArrayList<TimeUnitEnum>(Arrays.asList(DAY, WEEK, MONTH, FOREVER));
        effectiveTimeUnit.remove((Object)this);
        return effectiveTimeUnit;
    }

    public List<TimeUnitEnum> geOtherAwardTimeUnit() {
        ArrayList<TimeUnitEnum> effectiveTimeUnit = new ArrayList<TimeUnitEnum>(Arrays.asList(DAY, WEEK, MONTH));
        effectiveTimeUnit.remove((Object)this);
        return effectiveTimeUnit;
    }

    private static Date getWeekLastDay(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime localDateTime = LocalDateTime.of(localDate.with(DayOfWeek.SUNDAY), LocalTime.MAX);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private static Date getMonthLastDay(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime lastDateTime = LocalDateTime.of(localDate.with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MAX);
        return Date.from(lastDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

