package cn.com.duiba.galaxy.sdk.annotation.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动周期校验类型枚举
 *
 * @author fangxiaorun
 * @date 2022/11/18
 */
@Getter
@AllArgsConstructor
public enum ProjectCycleCheckTypeEnum {
    /**
     * 活动已开始
     */
    STARTED(1, "活动已开始"),
    /**
     * 活动未结束
     */
    NOT_ENDED(2, "活动未结束"),
    /**
     * 活动周期内
     */
    DURING_THE_CYCLE(3, "活动周期内");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;
}
