package cn.com.duiba.galaxy.sdk.api.pay.third.gd;


import cn.com.duiba.galaxy.sdk.api.pay.param.BasePayReq;

/**
 * Description:
 * <p> 华兴银行支付-订单创建请求信息
 * date: 2022/8/22 11:02 上午
 *
 * @author huakai
 */
public class GdhxPayNotifyRequest extends BasePayReq {

    /**
     * 订单号
     */
    private String outTradeNo;

    /**
     * 交易账户
     */
    private String account;

    /**
     * 付款金额 （单位分）
     */
    private String totalFee;

    /**
     * 支付流水单号
     */
    private String tradeNo;

    /**
     * 支付时间
     */
    private String notifyTime;

    public GdhxPayNotifyRequest(String outTradeNo, String account, String totalFee, String tradeNo, String notifyTime) {
        this.outTradeNo = outTradeNo;
        this.account = account;
        this.totalFee = totalFee;
        this.tradeNo = tradeNo;
        this.notifyTime = notifyTime;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(String totalFee) {
        this.totalFee = totalFee;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getNotifyTime() {
        return notifyTime;
    }

    public void setNotifyTime(String notifyTime) {
        this.notifyTime = notifyTime;
    }
}
