package cn.com.duiba.galaxy.sdk.api.pay.third.union.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

/**
 * 深圳银联-用户主动扫码支付-用户支付通知-银联参数
 *
 * @author liuyanghong
 */
public class SzQrcodeNotifyParam {

    /**
     * 版本号，version 默认值是 2.0
     */
    private String version;
    /**
     * 可选值 GBK、UTF-8
     */
    private String charset;
    /**
     * 签名算法
     */
    @JSONField(name = "sign_type")
    private String signType;
    /**
     * 0表示成功，非 0表示失败此字段是通信标识，非交易标识，
     * 交易是否成功需要查看 result_code来判断
     */
    private String status;
    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     */
    private String message;
    // ------------------  以下字段在 status 为 0 的时候有返回 ---------------
    /**
     * 0 表示成功，非 0 表示失败
     */
    @JSONField(name = "result_code")
    private String resultCode;
    /**
     * 商户号，由平台分配
     */
    private String merno;
    /**
     * 随机字符串，不长于 32 位
     */
    @JSONField(name = "nonce_str")
    private String nonceStr;
    /**
     * 参考错误码
     */
    @JSONField(name = "err_code")
    private String errCode;
    /**
     * 结果信息描述
     */
    @JSONField(name = "err_msg")
    private String errMsg;
    /**
     * 签名结果，详见“安全规范”
     */
    private String sign;

    // ------------------  以下字段在 status 和 result_code 都为 0 的时候有返回 ---------------

    /**
     * 原交易类型，详见附录
     */
    @JSONField(name = "trade_type")
    private String tradeType;
    /**
     * 平台交易单号
     */
    @JSONField(name = "transaction_id")
    private String transactionId;
    /**
     * 第三方订单号
     * 支付宝交易时，银联分套信息【固定 2位长度】 +支付宝 订单号
     * 微信交易时，微信交易单号
     * 云闪付交易时，付款凭证号
     */
    @JSONField(name = "out_transaction_id")
    private String outTransactionId;
    /**
     * 商户订单号 商户系统内部的定单号，32个字符内、可包含字母
     */
    @JSONField(name = "out_trade_no")
    private String outTradeNo;
    /**
     * 总金额，以分为单位，不允许包含任何字、符号
     */
    @JSONField(name = "total_fee")
    private Integer totalFee;
    /**
     * 货币类型，符合 ISO 4217标准的三位字母代码，
     * 默认人民币:CNY
     */
    @JSONField(name = "fee_type")
    private String feeType;
    /**
     * 附加信息 商家数据包，原样返回
     */
    private String attach;
    /**
     * 支付完成时间，格式为 yyyyMMddHHmmss，如 2009年 12月 27日 9点 10分 10秒表示为 20091227091010。时
     */
    @JSONField(name = "time_end")
    private String timeEnd;
    /**
     * 微信用户在服务商 appid 下的唯一标识
     */
    private String openid;
    /**
     * 支付宝用户登录账号
     */
    @JSONField(name = "buyer_logon_id")
    private String buyerLogonId;
    /**
     * 支付宝用户 ID
     */
    @JSONField(name = "buyer_user_id")
    private String buyerUserId;
    /**
     * 云闪付支付时，本域需整体做 Base64 编码，本域采用 JSON 格式，以方便扩展。本域全部内容用“[ ]”包含;内部可含 多个对象，每个对象用“{ }”包含，对象之间以“,”分隔。 详见下文说明:附件
     */
    private String couponInfo;
    /**
     * couponInfo转为列表对象
     */
    private List<CouponInfo> couponInfoList;


    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getMerno() {
        return merno;
    }

    public void setMerno(String merno) {
        this.merno = merno;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTransactionId() {
        return outTransactionId;
    }

    public void setOutTransactionId(String outTransactionId) {
        this.outTransactionId = outTransactionId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public Integer getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getTimeEnd() {
        return timeEnd;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getBuyerLogonId() {
        return buyerLogonId;
    }

    public void setBuyerLogonId(String buyerLogonId) {
        this.buyerLogonId = buyerLogonId;
    }

    public String getBuyerUserId() {
        return buyerUserId;
    }

    public void setBuyerUserId(String buyerUserId) {
        this.buyerUserId = buyerUserId;
    }

    public String getCouponInfo() {
        return couponInfo;
    }

    public void setCouponInfo(String couponInfo) {
        this.couponInfo = couponInfo;
        try {
            byte[] decode = Base64.getDecoder().decode(couponInfo);
            this.couponInfoList = JSON.parseArray(new String(decode, StandardCharsets.UTF_8), CouponInfo.class);
        } catch (Exception e) {
            //
        }
    }

    public List<CouponInfo> getCouponInfoList() {
        return couponInfoList;
    }

    public void setCouponInfoList(List<CouponInfo> couponInfoList) {
        this.couponInfoList = couponInfoList;
    }
}
