package cn.com.duiba.galaxy.sdk.api.prize;

import cn.com.duiba.galaxy.sdk.api.prize.inner.UserPrizeRecord;
import com.alibaba.fastjson.JSONObject;

import java.util.Date;

/**
 * 用户奖品记录VO
 *
 * @author fangxiaorun
 * @date 2022/10/31
 */
public class UserPrizeRecordVO implements UserPrizeRecord {

    /**
     * id
     */
    private Long id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 奖项id
     */
    private Long optionId;

    /**
     * 策略id
     */
    private String strategyId;

    /**
     * 发奖规则明细ID
     */
    private Long relationId;

    /**
     * 昵称
     */
    private String nickname;


    /**
     * 领奖状态 0初始化，1发奖中/扣库存中，2待领取，3领取中，4已领取，5领奖失败
     */
    private Integer drawStatus;

    /**
     * 扩展
     */
    private JSONObject extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 领奖单号
     */
    private String projectOrderNo;

    public String getProjectOrderNo() {
        return projectOrderNo;
    }

    public void setProjectOrderNo(String projectOrderNo) {
        this.projectOrderNo = projectOrderNo;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getOptionId() {
        return optionId;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Integer getDrawStatus() {
        return drawStatus;
    }

    public void setDrawStatus(Integer drawStatus) {
        this.drawStatus = drawStatus;
    }
}
