package cn.com.duiba.galaxy.sdk.api.tools.inner.lock;

/**
 * 分布式锁对象
 *
 * 使用方式：
 * 1.通过API创建一个DistributedLock对象，例如UserRequestApi.newLock(String key, int expireSeconds);
 *
 * 2.在临界区前尝试上锁：DistributedLock.tryLock()或DistributedLock.tryLock(int maxRetryTimes, long retryIntervalTimeMillis)
 * ，两个方法的差别是前者如果有锁竞争且竞争失败时将直接返回false，而后者将进行重试。
 *
 * 3.【如果第二步成功获取到锁】，那么在退出临界区后，需要调用DistributedLock.unlock()来释放锁。如果没有成功上锁但尝试释放锁将会抛出异常；如果重复释放锁，将会抛出异常;
 *
 * 示例代码：
 * DistributedLock distributedLock = userRequestApi.newLock("lock", 2);
 * if (distributedLock.tryLock()) {
 *   try {
 *     //临界区代码
 *   } finally {
 *     distributedLock.unlock();
 *   }
 * }
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DistributedLock.java , v 0.1 2019-11-05 11:45 ZhouFeng Exp $
 */
public interface DistributedLock {

    String PREFIX = "galaxy:lock:";

    /**
     * 尝试上锁
     *
     * @return 是否上锁成功
     */
    boolean tryLock();

    /**
     * 尝试上锁
     * 此方法在获取失败时会自动重试指定的次数,由于多次等待会阻塞当前线程，请尽量避免使用此方法
     *
     * @param maxRetryTimes           最大重试次数
     * @param retryIntervalTimeMillis 每次重试间隔（单位：毫秒）
     * @return boolean
     */
    boolean tryLock(int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * 解锁
     */
    void unlock();
}
