package cn.com.duiba.galaxy.sdk.component;


import cn.com.duiba.galaxy.sdk.api.base.Api;
import cn.com.duiba.galaxy.sdk.component.answer.AnswerApi;
import cn.com.duiba.galaxy.sdk.component.carousel.CarouselApi;
import cn.com.duiba.galaxy.sdk.component.checkin.CheckinApi;
import cn.com.duiba.galaxy.sdk.component.drawprize.DrawPrizeApi;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeApi;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteAssistApi;
import cn.com.duiba.galaxy.sdk.component.rank.RankApi;
import cn.com.duiba.galaxy.sdk.component.task.TaskApi;


/**
 * 组件api
 * <p>
 * 注意📢：在业务代码中调用api并发限制需要自己处理
 */
public interface ComponentApi extends Api {


    /**
     * 获取任务组件api
     */
    TaskApi getTaskApi();

    /**
     * 获取签到组件api
     */
    CheckinApi getCheckinApi();

    /**
     * 获取排行榜api
     */
    RankApi getRankApi();

    /**
     * 获得邀请助力api
     */
    InviteAssistApi getInviteAssistApi();

    /**
     * 获取轮播组件api
     */
    CarouselApi getCarouselApi();

    /**
     * 获取抽奖组件api
     *
     * @return {@link DrawPrizeApi}
     */
    DrawPrizeApi getDrawPrizeApi();

    /**
     * 获取答题组件api
     *
     * @return {@link AnswerApi}
     */
    AnswerApi getAnswerApi();

    /**
     * 获取兑换组件api
     * @return
     */
    ExchangeApi getExchangeApi();
}