package cn.com.duiba.galaxy.sdk.component.answer;

import cn.com.duiba.galaxy.common.utils.PageList;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.answer.dto.*;

/**
 * @author zhangdaqing
 * @Date 2023/3/13 15:34
 **/
public interface AnswerApi extends UserRequestApi {

    AnswerQueryResult query(String componentId);

    /**
     * 开始答题 ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     */
    AnswerStartResult start(String componentId, String extra);

    /**
     * 获取题目
     *
     * @param componentId 组件id
     * @param startId     开始id
     * @return {@link AnswerQuestionResult}
     */
    AnswerQuestionResult getQuestion(String componentId, Long startId);


    /**
     * 提交答案
     *
     * @param componentId 组件id
     * @param startId     开始id
     * @param answer      回答
     * @return {@link AnswerSubmitResult}
     */
    AnswerSubmitResult submit(String componentId, Long startId, String answer, String extra);

    /**
     * 查询题库
     *
     * @param param pageSize 最大200
     * @return
     */
    PageList<QuestionLibraryResult> findQuestionLibrary(QuestionLibraryParam param);


    /**
     * 完成答题
     *
     * @param componentId 组件id
     * @param startId     开始id
     * @return {@link AnswerCompletedResult}
     */
    AnswerCompletedResult completed(String componentId, Long startId);


}
