package cn.com.duiba.galaxy.sdk.component.answer;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerCompletedResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerQuestionResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerStartResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerSubmitResult;
import cn.com.duiba.galaxy.sdk.component.rank.RankConfigVo;

/**
 * @author zhangdaqing
 * @Date 2023/3/13 15:31
 **/
public abstract class AnswerComponentAction implements BaseComponentAction {

    @CustomRequestAction(id = "getQuestion", desc = "获取题目")
    public abstract AnswerQuestionResult getQuestion(UserRequestApi api);

    @CustomRequestAction(id = "start", desc = "开始答题")
    public abstract AnswerStartResult start(UserRequestApi api);

    @CustomRequestAction(id = "submit", desc = "提交答案")
    public abstract AnswerSubmitResult submit(UserRequestApi api);

    @CustomRequestAction(id = "doCompleted", desc = "完成答题")
    public abstract AnswerCompletedResult doCompleted(UserRequestApi api);
}
