package cn.com.duiba.galaxy.sdk.component.answer.dto;


import cn.com.duiba.galaxy.sdk.component.base.BaseResult;
import cn.com.duiba.galaxy.sdk.component.drawprize.dto.SendPrizeResult;

import java.util.List;

/**
 * 回答完成结果
 *
 * @author zhangdaqing
 * @date 2023/04/25
 */
public class AnswerCompletedResult extends BaseResult {

    /**
     * 全部答题结果
     */
    private List<AnswerResult> answerList;

    /**
     * 总题数
     */
    private Integer questionSize;

    /**
     * 正确数量
     */
    private Integer rightCount;

    /**
     * 总分数
     */
    private Integer totalScore;

    /**
     * 本次答题得到的奖品
     */
    private List<SendPrizeResult> options;

    public List<AnswerResult> getAnswerList() {
        return answerList;
    }

    public void setAnswerList(List<AnswerResult> answerList) {
        this.answerList = answerList;
    }

    public Integer getRightCount() {
        return rightCount;
    }

    public void setRightCount(Integer rightCount) {
        this.rightCount = rightCount;
    }

    public Integer getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public List<SendPrizeResult> getOptions() {
        return options;
    }

    public void setOptions(List<SendPrizeResult> options) {
        this.options = options;
    }

    public Integer getQuestionSize() {
        return questionSize;
    }

    public void setQuestionSize(Integer questionSize) {
        this.questionSize = questionSize;
    }
}
