package cn.com.duiba.galaxy.sdk.component.carousel;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.carousel.dto.CarouselResult;

/**
 * @author Hua.xy
 * @date 2023-01-06 16:48
 */

public class CarouselComponentActionDefault extends CarouselComponentAction {

    private final String componentId;

    public CarouselComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id = "queryCarousel", desc = "查询轮播数据")
    public CarouselResult queryCarousel(UserRequestApi api) {
        CarouselApi carouselApi = api.getComponentApi().getCarouselApi();
        return carouselApi.queryCarousel(componentId);
    }

}
