package cn.com.duiba.galaxy.sdk.component.checkin;

import cn.com.duiba.galaxy.sdk.UserRequestApi;

import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinOptionResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinResult;

import java.util.Date;
import java.util.List;

public interface CheckinApi extends UserRequestApi {

    /**
     * 查询奖品
     *
     * @param componentId 组件ID
     * @return
     */
    List<CheckinOptionResult> queryOptions(String componentId);

    /**
     * 签到, 不发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @return
     */
    CheckinResult doSign(String componentId, Long userId);

    /**
     * 签到, 不发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @param signTime    签到时间
     * @return
     */
    CheckinResult doSign(String componentId, Long userId, Date signTime);

    /**
     * 签到并发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @param signTime    签到时间
     * @return
     */
    CheckinResult doSignAndSendPrize(String componentId, Long userId, Date signTime);

    /**
     * 发奖
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @param signTime    签到时间
     * @return
     */
    StrategyResult sendPrize(String componentId, Long userId, Date signTime);

    /**
     * 查询
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @return
     */
    CheckinQueryResult query(String componentId, Long userId);

    /**
     * 查询
     *
     * @param componentId  组件ID
     * @param userId       用户ID
     * @param intervalType 查询类型,默认:0
     *                     -1=上个周期
     *                     0=当前周期
     * @return
     */
    CheckinQueryResult query(String componentId, Long userId, Integer intervalType);

    /**
     * 签到时间段查询
     *
     * @param componentId 组件ID
     * @param userId      用户ID
     * @param startDate   开始日期
     * @param endDate     结束日期
     * @return
     */
    CheckinQueryResult query(String componentId, Long userId, Integer intervalType, Date startDate, Date endDate);
}
