package cn.com.duiba.galaxy.sdk.component.drawprize.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;


/**
 * 抽奖奖品类型枚举
 *
 * @author fangxiaorun
 * @date 2023/02/03
 */
@Getter
@AllArgsConstructor
public enum DrawPrizeTypeEnum {
    /**
     * 道具
     */
    SP(1, "道具"),
    /**
     * 奖池抽奖
     */
    PRIZE_POOL(2, "奖池抽奖");

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;


    /**
     * 根据code获取枚举
     *
     * @param code 编码
     * @return {@link DrawPrizeTypeEnum}
     */
    public static DrawPrizeTypeEnum valueOfCode(Integer code) {
        return Arrays.stream(DrawPrizeTypeEnum.values()).filter(obj -> Objects.equals(obj.code, code)).findFirst().orElse(null);
    }
}
