package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;

/**
 * @author 刘佳辉
 * @since 2023/5/22
 */
public abstract class ExchangeComponentAction implements BaseComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.EXCHANGE;
    }


    @CustomRequestAction(id = "exchangeList", desc = "兑换列表")
    public  abstract ExchangeListResult exchangeList(UserRequestApi api);


    @CustomRequestAction(id = "exchangeAuth", desc = "兑换权限校验")
    public  abstract Integer exchangeAuth(UserRequestApi api);


    @CustomRequestAction(id = "doExchange", desc = "执行兑换")
    public  abstract ExchangeResult doExchange(UserRequestApi api);

    @CustomRequestAction(id = "deductCredits", desc = "扣积分")
    public  abstract String deductCredits(UserRequestApi api);


    /**
     * 查询扣积分状态
     *
     * @param api api
     * @return {@link Integer}
     */
    @CustomRequestAction(id = "queryDeductCreditsStatus", desc = "查询扣积分状态")
    public abstract Integer queryDeductCreditsStatus(UserRequestApi api);
}
