package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.common.utils.Conditions;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.Token;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.component.drawprize.DrawPrizeApi;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @author 刘佳辉
 * @since 2023/5/22
 */

public class ExchangeComponentActionDefault extends  ExchangeComponentAction{


    private final String componentId;

    public ExchangeComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id = "exchangeList", desc = "兑换列表")
    public ExchangeListResult exchangeList(UserRequestApi api) {
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.exchangeList(componentId);
    }

    @Override
    @CustomRequestAction(id = "exchangeAuth", desc = "兑换权限校验")
    public Integer exchangeAuth(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        ExchangeLimitEnum exchangeLimitEnum = exchangeApi.exchangeAuth(componentId, sign);
        return exchangeLimitEnum.getType();
    }

    @Override
    @Token
    @CustomRequestAction(id = "doExchange", desc = "执行兑换")
    @UserConcurrentLock
    public ExchangeResult doExchange(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.doExchange(componentId,sign);
    }



    /**
     * 扣积分
     *
     * @param api api
     * @return {@link PrizeResult}
     */
    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id = "deductCredits", desc = "扣积分")
    public String deductCredits(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.deductCredits(componentId, sign);
    }


    /**
     * 查询扣积分状态
     *
     * @param api api
     * @return {@link Integer}
     */
    @Override
    @CustomRequestAction(id = "queryDeductCreditsStatus", desc = "查询扣积分状态")
    public Integer queryDeductCreditsStatus(UserRequestApi api){
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        String ticket = api.getHttpRequest().getParameter("ticket");
        Conditions.expectTrue(StringUtils.isNotBlank(ticket), UnclassifiedStatusEnum.PARAM_ERROR.setDesc("积分门票不能为空") );
        return exchangeApi.queryDeductCreditsStatus(ticket);
    };
}
