package cn.com.duiba.galaxy.sdk.component.task;

import cn.com.duiba.galaxy.sdk.UserRequestApi;

import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;

/**
 * @author 刘佳辉
 * @since 2022/12/23
 */
public abstract class TaskComponentAction implements BaseComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.TASK;
    }


    /**
     * 查询任务列表
     *  调用 api.queryTasks()
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryTasks",desc = "查询任务")
    public abstract TaskQueryResult queryTasks(UserRequestApi api);

    /**
     * 完成任务 手动领奖
     *  请调用 api.doComplete()
     * @param api
     * @return
     */
    @CustomRequestAction(id = "doCompleted",desc = "完成任务")
    public abstract TaskResult doCompleted(UserRequestApi api);



    /**
     * 完成任务 自动发奖
     *  请调用 api.doComplete()
     * @param api
     * @return
     */
    @CustomRequestAction(id = "doCompletedSendPrize",desc = "完成任务自动发奖")
    public abstract TaskResult doCompletedSendPrize(UserRequestApi api);

    /**
     * 领奖
     * 请调用 api.sendPrize()
     * @param api
     * @return
     */
    @CustomRequestAction(id = "sendPrize",desc = "领奖")
    public abstract StrategyResult sendPrize(UserRequestApi api);


}
