/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.answer;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.Token;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.answer.AnswerComponentAction;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerCompletedResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerQuestionResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerStartResult;
import cn.com.duiba.galaxy.sdk.component.answer.dto.AnswerSubmitResult;
import org.apache.commons.lang3.StringUtils;

public class AnswerComponentActionDefault
extends AnswerComponentAction {
    private final String componentId;

    public AnswerComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.ANSWER;
    }

    @Override
    @UserConcurrentLock
    @CustomRequestAction(id="getQuestion", desc="\u83b7\u53d6\u9898\u76ee")
    public AnswerQuestionResult getQuestion(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return api.getComponentApi().getAnswerApi().getQuestion(this.componentId, startId);
    }

    @Override
    @UserConcurrentLock
    @CustomRequestAction(id="start", desc="\u5f00\u59cb\u7b54\u9898")
    public AnswerStartResult start(UserRequestApi api) {
        return api.getComponentApi().getAnswerApi().start(this.componentId, null);
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id="submit", desc="\u63d0\u4ea4\u7b54\u6848")
    public AnswerSubmitResult submit(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        String answer = api.getStringParameter("answer");
        if (StringUtils.isBlank((CharSequence)answer)) {
            throw new BizRuntimeException("answer\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return api.getComponentApi().getAnswerApi().submit(this.componentId, startId, answer, null);
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id="doCompleted", desc="\u5b8c\u6210\u7b54\u9898")
    public AnswerCompletedResult doCompleted(UserRequestApi api) {
        Long startId = api.getLongParameter("startId");
        if (startId == null) {
            throw new BizRuntimeException("startId\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return api.getComponentApi().getAnswerApi().completed(this.componentId, startId);
    }
}

