/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.exchange;

import cn.com.duiba.galaxy.common.message.BizError;
import cn.com.duiba.galaxy.common.utils.Conditions;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.Token;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeApi;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeComponentAction;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeLimitEnum;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeListResult;
import cn.com.duiba.galaxy.sdk.component.exchange.ExchangeResult;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class ExchangeComponentActionDefault
extends ExchangeComponentAction {
    private final String componentId;

    public ExchangeComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id="exchangeList", desc="\u5151\u6362\u5217\u8868")
    public ExchangeListResult exchangeList(UserRequestApi api) {
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.exchangeList(this.componentId);
    }

    @Override
    @CustomRequestAction(id="exchangeAuth", desc="\u5151\u6362\u6743\u9650\u6821\u9a8c")
    public Integer exchangeAuth(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        ExchangeLimitEnum exchangeLimitEnum = exchangeApi.exchangeAuth(this.componentId, sign);
        return exchangeLimitEnum.getType();
    }

    @Override
    @Token
    @CustomRequestAction(id="doExchange", desc="\u6267\u884c\u5151\u6362")
    @UserConcurrentLock
    public ExchangeResult doExchange(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.doExchange(this.componentId, sign);
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id="deductCredits", desc="\u6263\u79ef\u5206")
    public String deductCredits(UserRequestApi api) {
        String sign = api.getStringParameterCheckBlank("sign");
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        return exchangeApi.deductCredits(this.componentId, sign);
    }

    @Override
    @CustomRequestAction(id="queryDeductCreditsStatus", desc="\u67e5\u8be2\u6263\u79ef\u5206\u72b6\u6001")
    public Integer queryDeductCreditsStatus(UserRequestApi api) {
        ExchangeApi exchangeApi = api.getComponentApi().getExchangeApi();
        String ticket = api.getHttpRequest().getParameter("ticket");
        Conditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)ticket), (BizError)UnclassifiedStatusEnum.PARAM_ERROR.setDesc("\u79ef\u5206\u95e8\u7968\u4e0d\u80fd\u4e3a\u7a7a"));
        return exchangeApi.queryDeductCreditsStatus(ticket);
    }
}

