/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.inviteassist;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.utils.PageList;
import cn.com.duiba.galaxy.sdk.PlatformSdkErrorEnum;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.ProjectCycleCheck;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.DistributedLock;
import cn.com.duiba.galaxy.sdk.component.inviteassist.AssistRecordResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.AssistResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteAssistComponentAction;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteAssistQueryParam;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteRecordResult;
import cn.com.duiba.galaxy.sdk.component.inviteassist.InviteResult;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;

public class InviteAssistComponentActionDefault
extends InviteAssistComponentAction {
    private final String componentId;

    public InviteAssistComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id="getInviteCode", desc="\u83b7\u53d6\u9080\u8bf7\u7801")
    public InviteResult getInviteCode(UserRequestApi api) {
        return api.getComponentApi().getInviteAssistApi().getInviteCode(this.componentId);
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id="getInviteCodeCoverPeriod", desc="\u83b7\u53d6\u9080\u8bf7\u7801\u5e76\u5237\u65b0\u5df2\u8fc7\u671f\u9080\u8bf7\u7801\u65f6\u95f4")
    public InviteResult getInviteCodeCoverPeriod(UserRequestApi api) {
        return api.getComponentApi().getInviteAssistApi().getInviteCodeCoverPeriod(this.componentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ProjectCycleCheck
    @CustomRequestAction(id="doAssist", desc="\u52a9\u529b")
    public AssistResult doAssist(UserRequestApi api) {
        String inviteCode = api.getStringParameterCheckBlank("inviteCode");
        String extra = api.getStringParameter("extra");
        DistributedLock distributedLock = api.getLockApi().newLock(this.componentId + inviteCode);
        try {
            if (distributedLock.tryLock()) {
                AssistResult assistResult = api.getComponentApi().getInviteAssistApi().doAssist(this.componentId, inviteCode, extra);
                return assistResult;
            }
        }
        finally {
            distributedLock.unlock();
        }
        throw new BizRuntimeException(PlatformSdkErrorEnum.LOCK_ERROR.setDesc("\u52a9\u529b\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
    }

    @Override
    @CustomRequestAction(id="queryInviteRecords", desc="\u67e5\u8be2\u9080\u8bf7\u8bb0\u5f55")
    public PageList<InviteRecordResult> queryInviteRecords(UserRequestApi api) {
        InviteAssistQueryParam param = this.getRecordQueryParam(api);
        return api.getComponentApi().getInviteAssistApi().queryInviteRecords(param);
    }

    @Override
    @CustomRequestAction(id="queryAssistRecords", desc="\u67e5\u8be2\u52a9\u529b\u8bb0\u5f55")
    public PageList<AssistRecordResult> queryAssistRecords(UserRequestApi api) {
        InviteAssistQueryParam param = this.getRecordQueryParam(api);
        return api.getComponentApi().getInviteAssistApi().queryAssistRecords(param);
    }

    @Override
    @CustomRequestAction(id="queryNewInviteCount", desc="\u67e5\u8be2\u672a\u8bfb\u9080\u8bf7\u6570\u91cf")
    public int queryNewInviteCount(UserRequestApi api) {
        return api.getComponentApi().getInviteAssistApi().queryNewInviteCount(this.componentId, api.getUserId());
    }

    private InviteAssistQueryParam getRecordQueryParam(UserRequestApi api) {
        Integer pageNum = api.getIntegerParameterCheckNull("pageNum");
        Integer pageSize = api.getIntegerParameterCheckNull("pageSize");
        Long startDate = api.getLongParameter("startDate");
        Long endDate = api.getLongParameter("endDate");
        Integer distinctAssistUserId = api.getIntegerParameter("distinctAssistUserId", 0);
        Integer distinctShareUserId = api.getIntegerParameter("distinctShareUserId", 0);
        InviteAssistQueryParam param = new InviteAssistQueryParam();
        param.setComponentId(this.componentId);
        param.setProjectId(api.getActionContext().getProjectId());
        param.setDistinctAssistUserId(distinctAssistUserId.equals(1));
        param.setDistinctShareUserId(distinctShareUserId.equals(1));
        param.setPageNum(pageNum);
        param.setPageSize(pageSize);
        if (startDate != null) {
            param.setStartTime(new Date(startDate));
        } else {
            param.setStartTime(DateUtils.getDayStartTime((Date)new Date()));
        }
        if (endDate != null) {
            param.setEndTime(new Date(endDate));
        } else {
            param.setEndTime(DateUtils.getDayEndTime((Date)new Date()));
        }
        if (param.getStartTime().after(param.getEndTime())) {
            throw new BizRuntimeException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (param.getEndTime().getTime() - param.getStartTime().getTime() > 8640000000L) {
            throw new BizRuntimeException("\u65f6\u95f4\u5468\u671f\u4e0d\u80fd\u5927\u4e8e100\u5929");
        }
        return param;
    }
}

