package cn.com.duiba.galaxy.sdk.api.credits;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.api.credits.inner.CreditsRecord;
import cn.com.duiba.galaxy.sdk.api.credits.inner.DeductCreditsRequest;

import java.util.List;


/**
 * 积分操作api
 *
 * @author fangxiaorun
 * @date 2023/01/09
 */
public interface CreditsApi extends AutowiredApi {
    /**
     * 发起扣积分，返回扣积分门票
     *
     * @param request 请求
     * @return {@link String}
     */
    String deductCredits(DeductCreditsRequest request);

    /**
     * 扣积分门票是否可用
     *
     * @param userId    用户id
     * @param ticketNum 门票
     * @param credits   积分
     * @return boolean
     */
    boolean isCreditsTicketUsable(Long userId, String ticketNum, Long credits);

    /**
     * 使用扣积分门票
     *
     * @param userId    用户id
     * @param ticketNum 门票
     * @return {@link Boolean}
     */
    Boolean useCreditsTicket(Long userId, String ticketNum);

    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 门票
     * @return {@link CreditsRecord}
     */
    CreditsRecord getCreditsTicket(String ticketNum);

    /**
     * 获取当前用户对应玩法动作下对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param userId   用户id
     * @param quantity 数量
     * @return {@link List}<{@link CreditsRecord}>
     */
    List<CreditsRecord> findUnusedTicketList(Long userId, Long quantity);
}
