package cn.com.duiba.galaxy.sdk.api.redis.inner;

import java.util.List;
import java.util.Objects;

/**
 * redis可选限制的自增结果
 *
 * @author fangxiaorun
 * @date 2022/05/09
 */
public class RedisIncrWithLimitResult {
    /**
     * 是否操作成功
     */
    private boolean success;

    /**
     * 当前值
     * ⚠️ 可为null（当key不存在/过期/被删除,因值范围不限制为正整数，所以不能默认值为0)
     */
    private Long currentValue;

    public RedisIncrWithLimitResult(List<Long> list) {
        success = Objects.equals(list.get(0), 1L);
        if (list.size() > 1) {
            currentValue = list.get(1);
        }
    }

    public RedisIncrWithLimitResult() {
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean isSuccess) {
        this.success = isSuccess;
    }

    public Long getCurrentValue() {
        return currentValue;
    }

    public void setCurrentValue(Long currentValue) {
        this.currentValue = currentValue;
    }
}
