package cn.com.duiba.galaxy.sdk.apiextra;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.apiextra.inner.UserData;

import java.util.Date;
import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-03
 * 时间偏差可通过DateUtil.offsetSecond(new Date(), 3)实现
 *
 * ⚠️此类请通过value判断场景，请勿通过是否为null判断。
 * 原因：
 * 若一个事务由于阻塞等原因长时间未提交插入事务，后续请求由于不同事务将查不到数据，也会插入数据，
 * 此时排他锁和共享锁互斥，容易出现死锁场景，因此该类通过新事务插入全新数据。即事务回滚也会出现value为null的数据
 */
public interface UserDataApi extends AutowiredApi {

    /**
     * 添加用户数据
     *
     * @param userId    用户id
     * @param key       key
     * @param content   value
     * @param expireTime 过期时间--时间偏差可通过DateUtil.offsetSecond(new Date(), 3)实现
     *                   为null时不变更过期时间
     * @return
     */
    void addOrUpdateUserData(Long userId, String key, String content, Date expireTime);


    void addOrUpdateUserData(Long userId, String key, String content);


    void addOrUpdateUserData(Long userId, String key, Long content, Date expireTime);


    void addOrUpdateUserData(Long userId, String key, Long content);


    /**
     * 查询用户数据
     *
     * @param userId
     * @param key
     * @param expire 是否查询过期数据，true：包含过期时间，false不包含过期时间
     * @return 用户数据，不存在则返回null
     */
    String query(Long userId, String key, boolean expire);


    Long queryLong(Long userId, String key, boolean expire);


    /**
     * 查询用户数据
     *
     * @param userId
     * @return 用户数据所有key的数据，包含过期数据
     */
    List<UserData> query(Long userId);


    /**
     * 批量查询用户数据，不包括过期数据
     * 请保证userId数量，避免一次性查询过多数量
     *
     * @param key     key
     * @param userIds user ids
     * @return user data listk
     */
    List<UserData> batchListUserData(String key, List<String> userIds);


}
