package cn.com.duiba.galaxy.sdk.component.task;

import cn.com.duiba.galaxy.sdk.component.TimeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;


@Data
public class TaskItemResult {

    /**
     * 玩法ID
     */
    private String componentId;

    /**
     * 任务ID
     */
    private String id;

    /**
     * 任务标识
     */
    private String code;


    /**
     * 任务标识
     */
    private String codeName;

    /**
     * 任务标题
     */
    private String title;

    /**
     * 任务副标题
     */
    private String subTitle;

    /**
     * 任务描述
     */
    private String desc;

    /**
     * 任务图标
     */
    private String icon;

    /**
     * 按钮文案
     */
    private String buttonText;

    /**
     * 任务跳转URL
     */
    private String jumpUrl;

    /**
     * 任务限制类型
     * 0=不限制
     * 1=日
     * 2=周
     * 3=月
     * 4=永久
     */
    private Integer intervalType;

    /**
     * 任务限制次数
     */
    private Integer intervalLimitSize;

    /**
     * 已完成的次数
     */
    private Integer completedSize;

    /**
     * 任务状态
     * 0 去完成，任务完成次数未达到上限
     * 1 待领奖
     * 2 已完成，任务完成次数达到上限
     */
    private Integer taskStatus;

    /**
     * 扩展字段
     */
    private String extra;

    /**
     * 当前这一次是否发奖
     */
    private Boolean sendPrize;


    /**
     * 发件规则Id
     */
    private String ruleId;


    /**
     * 发奖规则名称
     */
    private String ruleName;


    /**
     * 道具id
     */
    private String spId;


    /**
     * 道具数量
     */
    private Long spNum;


    /**
     * 领奖Code
     */
    private String prizePendingCode;


    /**
     * 排序
     */
    private Integer pos;



    @JsonSerialize(using = TimeSerializer.LocalDateTimeSerializer.class)
    private LocalDateTime startTime;

    @JsonSerialize(using = TimeSerializer.LocalDateTimeSerializer.class)
    private LocalDateTime endTime;


    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 获得任务状态
     *
     * @return
     */
    public Integer getTaskStatus() {
        if (StringUtils.isNoneBlank(prizePendingCode)) {
            return 1;
        }
        if (intervalType == 0 || intervalLimitSize == null) {
            return 0;
        }
        if (completedSize == null) {
            return 0;
        }
        if (completedSize < intervalLimitSize) {
            return 0;
        }
        return 2;
    }


    public String getComponentId() {
        return componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeName() {
        return codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public Integer getIntervalType() {
        return intervalType;
    }

    public void setIntervalType(Integer intervalType) {
        this.intervalType = intervalType;
    }

    public Integer getIntervalLimitSize() {
        return intervalLimitSize;
    }

    public void setIntervalLimitSize(Integer intervalLimitSize) {
        this.intervalLimitSize = intervalLimitSize;
    }

    public Integer getCompletedSize() {
        return completedSize;
    }

    public void setCompletedSize(Integer completedSize) {
        this.completedSize = completedSize;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Boolean getSendPrize() {
        return sendPrize;
    }

    public void setSendPrize(Boolean sendPrize) {
        this.sendPrize = sendPrize;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getSpId() {
        return spId;
    }

    public void setSpId(String spId) {
        this.spId = spId;
    }

    public Long getSpNum() {
        return spNum;
    }

    public void setSpNum(Long spNum) {
        this.spNum = spNum;
    }

    public String getPrizePendingCode() {
        return prizePendingCode;
    }

    public void setPrizePendingCode(String prizePendingCode) {
        this.prizePendingCode = prizePendingCode;
    }

    public Integer getPos() {
        return pos;
    }

    public void setPos(Integer pos) {
        this.pos = pos;
    }
}
