package cn.com.duiba.galaxy.sdk.api.pay.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 退款状态枚举
 *
 * @author fangxiaorun
 * @date 2023/01/10
 */
@Getter
@AllArgsConstructor
public enum RefundStatusEnum {
    /**
     * 初始状态
     */
    REFUND_STATUS_INIT(0,"初始状态"),
    /**
     * 成功
     */
    REFUND_STATUS_SUC(1,"成功"),
    /**
     * 失败
     */
    REFUND_STATUS_FAIL(2,"失败"),
    /**
     * 处理中
     */
    REFUND_STATUS_PROCESSING(3, "处理中");

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;
}
