package cn.com.duiba.galaxy.sdk.api.pay.param;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;


/**
 * 支付记录DTO
 *
 * @author fangxiaorun
 * @date 2023/01/10
 */
@Getter
@Setter
public class PayRecordDto implements Serializable {

    private static final long serialVersionUID = 341734753354155644L;

    /**
     * id
     */
    private Long id;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 数量
     */
    private Long amount;

    /**
     * 支付银行
     */
    private String payBank;

    /**
     * 支付状态
     */
    private int payStatus;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 帐户状态
     */
    private int accountStatus;

    /**
     * 支付订单
     */
    private String payOrderNo;

    /**
     * 退款状态
     */
    private int refundStatus;

    /**
     * 退款订单
     */
    private String refundOrderNo;

    /**
     * 扩展信息
     */
    private String extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
