package cn.com.duiba.galaxy.sdk.api.tools;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.api.redis.RedisApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.area.IpAreaData;
import cn.com.duiba.galaxy.sdk.api.tools.inner.area.PhoneAreaData;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.LockApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.logger.BuriedPointService;
import cn.com.duiba.galaxy.sdk.api.tools.inner.risk.RiskControlApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.transaction.ProjectTransactionApi;

import java.util.Map;

/**
 * 工具api
 *
 * @author jiaxz
 * @date 2023/01/10
 */
public interface ToolsApi extends AutowiredApi {
    /**
     * 给指定的内容签名（响应带签名的map）
     *
     * @param appId       app id 必传
     * @param signContent 需要签名的内容
     * @return {@link Map}<{@link String}, {@link String}>
     */
    Map<String, String> doSign(Long appId, Map<String, String> signContent);

    /**
     * 查询手机号归属地信息
     *
     * @param phone 电话
     * @return {@link PhoneAreaData}
     */
    PhoneAreaData queryPhoneAreaData(String phone);

    /**
     * 获取事务api
     *
     * @return {@link ProjectTransactionApi}
     */
    ProjectTransactionApi getTransactionApi();

    /**
     * 获取埋点服务
     *
     * @return {@link BuriedPointService}
     */
    BuriedPointService getBuriedPointService();

//    /**
//     * 获取用户黑名单白名单的api
//     * @return
//     */
//    UserListServiceApi getUserListServiceApi();

    /**
     * 获取ip及所在地
     *
     * @param ip ip
     * @return {@link IpAreaData}
     */
    IpAreaData getIpData(String ip);

    /**
     * 获取RedisAPi
     *
     * @return {@link RedisApi}
     */
    RedisApi getRedisApi();

    /**
     * 获取锁Api
     *
     * @return {@link LockApi}
     */
    LockApi getLockApi();


    /**
     * 获得风控api
     * @return
     */
    RiskControlApi getRiskControlApi();

}
