package cn.com.duiba.galaxy.sdk.api.tools.inner.lock;

/**
 * LockApi
 *
 * @author jiaxz
 * @since 2022-12-30
 */
public interface LockApi {

    /**
     * 创建一个分布式锁对象[底层由兑吧定制的RedisAtomicClient实现]
     * 过期时间，默认3秒
     *
     * @param key 键
     * @return {@link DistributedLock}
     */
    DistributedLock newLock(String key);

    /**
     * 创建一个分布式锁对象[底层由兑吧定制的RedisAtomicClient实现]
     *
     * @param key           键
     * @param expireSeconds 过期时间，单位：秒
     * @return {@link DistributedLock}
     */
    DistributedLock newLock(String key, int expireSeconds);
}
