package cn.com.duiba.galaxy.sdk.api.user;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;

import java.util.Map;


/**
 * [积分商城]DcustomApi
 *
 * @author fangxiaorun
 * @date 2023/01/11
 */
public interface DcustomApi extends AutowiredApi {

    /**
     * 获取所有dcustom参数
     *
     * @return {@link Map}<{@link String}, {@link String}>
     */
    Map<String, String> getMap();

    /**
     * 获取头像
     *
     * @return {@link String}
     */
    String getAvatar();

    /**
     * 获取昵称
     *
     * @return {@link String}
     */
    String getNickName();

    /**
     * 是否关注微信公众号标识判定
     *  followOfficalAccount=1（未关注微信公共号）
     *  followOfficalAccount=0（已关注微信公众号）
     *
     * @return boolean
     */
    boolean isFollowOfficialAccount();
}
