package cn.com.duiba.galaxy.sdk.component.checkin;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.Token;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinOptionResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinResult;
import cn.com.duiba.wolf.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @author qiurenjie
 * @date 2023-01-06 16:48
 */

public class CheckinComponentActionDefault extends CheckinComponentAction {

    private final String componentId;

    public CheckinComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @Token
    @UserConcurrentLock
    @CustomRequestAction(id = "doSign", desc = "签到")
    public CheckinResult doSign(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();
        return checkinApi.doSignAndSendPrize(componentId, api.getUserId(), new Date());
    }

    @Override
    @CustomRequestAction(id = "query", desc = "查询签到记录-用户维度，非签到维度")
    public CheckinQueryResult query(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();

        Integer intervalType = api.getIntegerParameter("intervalType", 0);
        String startDateStr = api.getStringParameter("startDate");
        Date startDate = StringUtils.isNotBlank(startDateStr) ? DateUtils.getDayStartTime(startDateStr) : null;

        String endDateStr = api.getStringParameter("endDate");
        Date endDate = StringUtils.isNotBlank(endDateStr) ? DateUtils.getDayStartTime(endDateStr) : null;
        return checkinApi.query(componentId, api.getUserId(), intervalType, startDate, endDate);
    }

    @Override
    @CustomRequestAction(id = "queryOptions", desc = "查询签到奖品配置")
    public List<CheckinOptionResult> queryOptions(UserRequestApi api) {
        CheckinApi checkinApi = api.getComponentApi().getCheckinApi();
        return checkinApi.queryOptions(componentId);
    }
}
