package cn.com.duiba.galaxy.sdk.component.drawprize;


import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.base.DrawPrizeQueryResult;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.component.drawprize.dto.DrawPrizeOptionResult;

/**
 * 抽奖组件玩法
 *
 * @author fangxiaorun
 * @date 2023/02/02
 */
public abstract class DrawPrizeComponentAction implements BaseComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.DRAWPRIZE;
    }

    /**
     * 查询用户参与抽奖的基础信息
     *
     * @param api api
     * @return {@link DrawPrizeOptionResult}
     */
    @CustomRequestAction(id = "queryUserInfo", desc = "查询用户参与抽奖的基础信息")
    public abstract DrawPrizeQueryResult queryUserInfo(UserRequestApi api);

    /**
     * 抽奖
     *
     * @param api api
     * @return {@link PrizeResult}
     */
    @CustomRequestAction(id = "drawPrize", desc = "抽奖")
    public abstract PrizeResult drawPrize(UserRequestApi api);

    /**
     * 扣积分
     *
     * @param api api
     * @return {@link String}
     */
    @CustomRequestAction(id = "deductCredits", desc = "扣积分")
    public abstract String deductCredits(UserRequestApi api);

    /**
     * 查询扣积分状态
     *
     * @param api api
     * @return {@link Integer}
     */
    @CustomRequestAction(id = "queryDeductCreditsStatus", desc = "查询扣积分状态")
    public abstract Integer queryDeductCreditsStatus(UserRequestApi api);
}
