package cn.com.duiba.galaxy.sdk.component.task;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.ProjectCycleCheck;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;


/**
 * 任务组件
 * <p>
 * 注意📢：此处需要自行处理并发问题
 *
 * @author 刘佳辉
 * @since 2022/12/23
 */
public class TaskComponentActionDefault extends TaskComponentAction {

    private final String componentId;

    public TaskComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id = "queryTasks", desc = "查询任务")
    public TaskQueryResult queryTasks(UserRequestApi api) {


        TaskApi taskApi = api.getComponentApi().getTaskApi();

        return taskApi.queryTasks(componentId, api.getUserId());
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id = "doCompleted", desc = "完成任务")
    public TaskResult doCompleted(UserRequestApi api) {
        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode");

        return taskApi.doCompletedForCode(componentId, api.getUserId(), taskCode);
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id = "doCompletedSendPrize", desc = "完成任务自动发奖")
    public TaskResult doCompletedSendPrize(UserRequestApi api) {

        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode","任务code不能空");

        return taskApi.doCompletedAndSendPrizeForCode(componentId, api.getUserId(), taskCode);
    }

    @Override
    @ProjectCycleCheck
    @CustomRequestAction(id = "sendPrize", desc = "领奖")
    public StrategyResult sendPrize(UserRequestApi api) {

        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode","任务code不能空");

        String prizePendingCode = api.getStringParameterCheckBlank("prizePendingCode","领奖码不能为空");

        return taskApi.sendPrizeForCode(componentId, api.getUserId(), taskCode, prizePendingCode);
    }
}
