package cn.com.duiba.live.activity.center.api.bean.citic.mgm;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022/05/17 11:20
 * @description MGM - M2信息详情
 */
@Data
public class MgmM2InfoBean implements Serializable {

    private static final long serialVersionUID = -7160647889176948643L;

    /**
     * 被推荐人姓名(脱敏)
     * 例如：王**
     */
    private String custLocalName;

    /**
     * 被推荐人手机号(脱敏)
     * 例如：132****1234
     */
    private String custMobilePhone;

    /**
     * 申卡时间
     * 例如：yyyyMMdd
     */
    private Date createDate;

    /**
     * 初审日期
     * 例如：yyyyMMdd
     */
    private Date preAprvEndDt;

    /**
     * 激活日期
     * 例如：yyyyMMdd
     */
    private Date activationTime;

    /**
     * 首刷日期
     * 例如：yyyyMMdd
     */
    private Date cardFirstPurchaseDte;

    /**
     * 审批状态
     * {@link cn.com.duiba.live.activity.center.api.enums.citic.mgm.MgmM2StatusEnum}
     */
    private String cardStatusDesc;

    /**
     * 是否新户, 是/否
     */
    private String newCustFlag;

    /**
     * 申卡流水号
     */
    private String referenceNo;

}
