package cn.com.duiba.live.activity.center.api.remoteservice.citic.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.bean.citic.mgm.MgmM2InfoBean;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/05/24 10:21
 * @description 中信MGM活动 - 与中信交互 RPC 接口
 */
@AdvancedFeignClient
public interface RemoteMgmApiService {

    /**
     * 查询M1邀请进度
     *
     * @param promotionCode 推荐码
     * @return 邀请进度
     */
    List<MgmM2InfoBean> listM2Info(String promotionCode);

    /**
     * 获取申卡链接分享时间
     *
     * @return 分享时间
     */
    String getApplyLinkShareTime();

    /**
     * 发送档位变更短信
     *
     * @param promotionCode 推荐码
     * @param level         档位
     * @return 发送结果
     */
    boolean sendLevelChangeMsg(String promotionCode, Integer level);

}
