package cn.com.duiba.live.activity.center.api.remoteservice.community.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.community.invitation.CommunityInvitationConfigDto;
import cn.com.duiba.live.activity.center.api.param.community.invitation.CommunityInvitationConfigQuery4Mng;
import cn.com.duiba.live.activity.center.api.param.community.invitation.CommunityInvitationConfigQueryParam;

import java.util.List;

/**
 * @author ouyang
 * @date 2022-05-25 11：09
 * @description 社群邀约活动配置 Service
 */
@AdvancedFeignClient
public interface RemoteCommunityInvitationConfigService {

    /**
     * 新增
     *
     * @param dto 用户积分详情
     * @return 主键Id
     */
    Long insert(CommunityInvitationConfigDto dto);

    /**
     * 更新
     *
     * @param dto 用户积分详情
     * @return 执行结果
     */
    int update(CommunityInvitationConfigDto dto);

    /**
     * 获取用户积分规则
     *
     * @param companyId  公司Id
     * @return 用户积分配置列表
     */
    List<CommunityInvitationConfigDto> findByCompanyId(Long companyId);

    /**
     * 获取用户积分规则
     *
     * @param id  id
     * @return 用户积分配置列表
     */
    CommunityInvitationConfigDto findById(Long id);

    /**
     * 分页列表
     *
     * @param param 查询参数
     * @return 分页列表
     */
    List<CommunityInvitationConfigDto> selectPageList(CommunityInvitationConfigQueryParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return count
     */
    Long selectCount(CommunityInvitationConfigQueryParam param);


    List<CommunityInvitationConfigDto> selectList4Manager(CommunityInvitationConfigQuery4Mng query4Mng);

    Long selectCount4Manager(CommunityInvitationConfigQuery4Mng query4Mng);

    List<CommunityInvitationConfigDto> listByIds(List<Long> ids);
}
