package cn.com.duiba.live.activity.center.api.remoteservice.community.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.community.invitation.CommunityInvitationDrainageDto;
import java.util.List;

/**
 * @author ouyang
 * @date 2022-05-25 11：09
 * @description 社群邀约分享渠道 Service
 */
@AdvancedFeignClient
public interface RemoteCommunityInvitationDrainageService {

    /**
     * 新增
     *
     * @param dto 社区渠道
     * @return 主键Id
     */
    Long insert(CommunityInvitationDrainageDto dto);

    /**
     * 更新
     *
     * @param dto 社区渠道
     * @return 执行结果
     */
    int update(CommunityInvitationDrainageDto dto);

    /**
     * 获取社区渠道
     *
     * @param companyId  公司Id
     * @return 获取社区渠道列表
     */
    List<CommunityInvitationDrainageDto> findByCompanyId(Long companyId);

    /**
     * 获取社区渠道
     *
     * @param configId  邀约活动配置id
     * @return 获取社区渠道列表
     */
    List<CommunityInvitationDrainageDto> findByConfigId(Long configId);


    /**
     * 获取社区渠道
     *
     * @param id  id
     * @return 获取社区渠道
     */
    CommunityInvitationDrainageDto findById(Long id);


}
