/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.activity.center.api.enums.citic.mgm;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum MgmM2StatusEnum {
    NOT_MATCH(1, "\u4e0d\u7b26\u5408\u529e\u5361\u6761\u4ef6", ""),
    REJECT(2, "\u5ba1\u6279\u62d2\u7edd", "\u5df2\u62d2\u7edd"),
    FIRST_AUDIT_PASS(3, "\u521d\u5ba1\u901a\u8fc7", "\u5f85\u9762\u7b7e"),
    ACTIVATE(4, "\u5df2\u6fc0\u6d3b", "\u5df2\u6279\u6838"),
    CONSUME(5, "\u5b8c\u6210\u9996\u5237", "\u5df2\u9996\u5237"),
    APPLY(6, "\u7533\u8bf7", "\u5ba1\u6838\u4e2d"),
    INVALID(7, "\u65e0\u6548", ""),
    UNKNOWN(8, "\u672a\u77e5", "");

    public static final Set<Integer> INVITE_LIST;
    public static final Set<Integer> NO_NEW_CUST_FLAG_LIST;
    private static final Map<String, MgmM2StatusEnum> CARD_DESC_MAP;
    private final Integer status;
    private final String desc;
    private final String cardDesc;

    public static MgmM2StatusEnum getByCardDesc(String cardDesc) {
        if (StringUtils.isBlank((CharSequence)cardDesc)) {
            return null;
        }
        return CARD_DESC_MAP.get(cardDesc);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getCardDesc() {
        return this.cardDesc;
    }

    private MgmM2StatusEnum(Integer status, String desc, String cardDesc) {
        this.status = status;
        this.desc = desc;
        this.cardDesc = cardDesc;
    }

    static {
        INVITE_LIST = Collections.unmodifiableSet(Stream.of(APPLY.getStatus(), FIRST_AUDIT_PASS.getStatus(), ACTIVATE.getStatus()).collect(Collectors.toSet()));
        NO_NEW_CUST_FLAG_LIST = Collections.unmodifiableSet(Stream.of(APPLY.getStatus(), FIRST_AUDIT_PASS.getStatus(), REJECT.getStatus()).collect(Collectors.toSet()));
        CARD_DESC_MAP = Collections.unmodifiableMap(Arrays.stream(MgmM2StatusEnum.values()).filter(m2Status -> StringUtils.isNotBlank((CharSequence)m2Status.getCardDesc())).collect(Collectors.toMap(MgmM2StatusEnum::getCardDesc, Function.identity(), (v1, v2) -> v2)));
    }
}

