/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.activity.center.api.util.citic.mgm;

import cn.com.duiba.live.activity.center.api.util.citic.mgm.BigIntegerUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Base64;

public class KzxSM2Utils {
    private static final String PROVIDER = "BC";
    private static final String SM2_CURVE_NAME = "sm2p256v1";
    private static final String SM2_NAME = "SM2";

    public static KeyPair generateSM2KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(SM2_CURVE_NAME);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", PROVIDER);
        SecureRandom secureRandom = new SecureRandom();
        keyPairGenerator.initialize(ecGenParameterSpec, secureRandom);
        return keyPairGenerator.generateKeyPair();
    }

    public static String getPrivateKey(KeyPair keyPair) throws Exception {
        String base64SM2Privatekey = null;
        byte[] array = BigIntegerUtils.asUnsigned32ByteArray(((ECPrivateKey)keyPair.getPrivate()).getS());
        base64SM2Privatekey = new String(Base64.encode((byte[])array));
        return base64SM2Privatekey;
    }

    public static String getPublicKey(KeyPair keyPair) throws Exception {
        String base64SM2Publickey = null;
        byte[] x = BigIntegerUtils.asUnsigned32ByteArray(((ECPublicKey)keyPair.getPublic()).getW().getAffineX());
        byte[] y = BigIntegerUtils.asUnsigned32ByteArray(((ECPublicKey)keyPair.getPublic()).getW().getAffineY());
        byte[] pubBytes = new byte[x.length + y.length + 1];
        pubBytes[0] = 4;
        System.arraycopy(x, 0, pubBytes, 1, x.length);
        System.arraycopy(y, 0, pubBytes, x.length + 1, y.length);
        base64SM2Publickey = new String(Base64.encode((byte[])pubBytes));
        return base64SM2Publickey;
    }

    public static ECPublicKeyParameters generatePublicKey(byte[] pukByts) throws Exception {
        X9ECParameters sm2ECParameterSpec = GMNamedCurves.getByName((String)SM2_CURVE_NAME);
        ECPoint ecPoint = sm2ECParameterSpec.getCurve().decodePoint(pukByts);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameterSpec.getCurve(), sm2ECParameterSpec.getG(), sm2ECParameterSpec.getN());
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(ecPoint, domainParameters);
        return publicKeyParameters;
    }

    public static byte[] encrypt(String base64SM2Publickey, byte[] data) throws Exception {
        byte[] raw = KzxSM2Utils.encrypt(KzxSM2Utils.generatePublicKey(Base64.decode((byte[])base64SM2Publickey.getBytes())), data);
        return KzxSM2Utils.converToDER(raw);
    }

    private static byte[] encrypt(ECPublicKeyParameters publicKeyParameters, byte[] data) throws Exception {
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        return sm2Engine.processBlock(data, 0, data.length);
    }

    public static byte[] decrypt(String base64SM2Privatekey, byte[] encryptedData) throws Exception {
        byte[] data = KzxSM2Utils.convertToRaw(encryptedData);
        return KzxSM2Utils.decrypt(KzxSM2Utils.generatePrivateKey(Base64.decode((byte[])base64SM2Privatekey.getBytes())), data);
    }

    public static String sign(String base64SM2PrivateKey, byte[] tbsData) throws Exception {
        byte[] signature = KzxSM2Utils.sign(KzxSM2Utils.genPrivateKey(Base64.decode((byte[])base64SM2PrivateKey.getBytes())), tbsData);
        return new String(Base64.encode((byte[])signature));
    }

    public static boolean verify(String base64SM2PublicKey, byte[] tbsData, byte[] signature) throws Exception {
        signature = Base64.decode((byte[])signature);
        return KzxSM2Utils.verify(KzxSM2Utils.genPublicKey(Base64.decode((byte[])base64SM2PublicKey.getBytes())), tbsData, signature);
    }

    public static boolean verify(PublicKey publicKey, byte[] data, byte[] signedData) throws Exception {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), PROVIDER);
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(signedData);
    }

    private static byte[] sign(PrivateKey privateKey, byte[] data) throws Exception {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), PROVIDER);
        signature.initSign(privateKey, new SecureRandom());
        signature.update(data);
        return signature.sign();
    }

    public static ECPrivateKeyParameters generatePrivateKey(byte[] prkByts) throws Exception {
        X9ECParameters sm2ECParameterSpec = GMNamedCurves.getByName((String)SM2_CURVE_NAME);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameterSpec.getCurve(), sm2ECParameterSpec.getG(), sm2ECParameterSpec.getN());
        byte[] pBytes = new byte[32];
        System.arraycopy(prkByts, 0, pBytes, 0, 32);
        BigInteger d = new BigInteger(1, pBytes);
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    private static PrivateKey genPrivateKey(byte[] prkByts) throws Exception {
        X9ECParameters sm2ECParameterSpec = GMNamedCurves.getByName((String)SM2_CURVE_NAME);
        ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameterSpec.getCurve(), sm2ECParameterSpec.getG(), sm2ECParameterSpec.getN(), sm2ECParameterSpec.getH());
        byte[] pBytes = new byte[32];
        System.arraycopy(prkByts, 0, pBytes, 0, 32);
        BigInteger d = new BigInteger(1, pBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", PROVIDER);
        PrivateKey privateKey = keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(d, ecParameterSpec));
        return privateKey;
    }

    public static PublicKey genPublicKey(byte[] pukByts) throws Exception {
        X9ECParameters sm2ECParameterSpec = GMNamedCurves.getByName((String)SM2_CURVE_NAME);
        ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameterSpec.getCurve(), sm2ECParameterSpec.getG(), sm2ECParameterSpec.getN(), sm2ECParameterSpec.getH());
        ECPoint ecPoint = sm2ECParameterSpec.getCurve().decodePoint(pukByts);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", PROVIDER);
        return keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
    }

    private static byte[] decrypt(ECPrivateKeyParameters ecPrivateKeyParameters, byte[] data) throws Exception {
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        return sm2Engine.processBlock(data, 0, data.length);
    }

    public static byte[] converToDER(byte[] data) {
        String hexData = ByteUtils.toHexString((byte[])data);
        ASN1EncodableVector sm2Vec = new ASN1EncodableVector();
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(data, 1, x, 0, x.length);
        System.arraycopy(data, 33, y, 0, y.length);
        ASN1Integer C1CoordX = new ASN1Integer(new BigInteger(1, x));
        ASN1Integer C1CoordY = new ASN1Integer(new BigInteger(1, y));
        byte[] s = new byte[32];
        System.arraycopy(data, 65, s, 0, s.length);
        DEROctetString C3 = new DEROctetString(s);
        sm2Vec.add((ASN1Encodable)C1CoordX);
        sm2Vec.add((ASN1Encodable)C1CoordY);
        sm2Vec.add((ASN1Encodable)C3);
        byte[] tbd = new byte[data.length - 97];
        System.arraycopy(data, 97, tbd, 0, data.length - 97);
        DEROctetString C2 = new DEROctetString(tbd);
        sm2Vec.add((ASN1Encodable)C2);
        DERSequence sm2Seq = new DERSequence(sm2Vec);
        try {
            return sm2Seq.getEncoded();
        }
        catch (IOException var11) {
            var11.printStackTrace();
            return new byte[0];
        }
    }

    public static byte[] convertToRaw(byte[] data) throws Exception {
        String c1yHex;
        ASN1InputStream asn1InputStream = new ASN1InputStream(data);
        ASN1Sequence sm2Seq = (ASN1Sequence)asn1InputStream.readObject();
        ASN1Integer c1x = (ASN1Integer)sm2Seq.getObjectAt(0);
        ASN1Integer c1y = (ASN1Integer)sm2Seq.getObjectAt(1);
        DEROctetString c3 = (DEROctetString)sm2Seq.getObjectAt(2);
        DEROctetString c2 = (DEROctetString)sm2Seq.getObjectAt(3);
        String c1xHex = ByteUtils.toHexString((byte[])c1x.getPositiveValue().toByteArray());
        if ("00".equals(c1xHex.substring(0, 2))) {
            c1xHex = c1xHex.substring(2);
        }
        if ("00".equals((c1yHex = ByteUtils.toHexString((byte[])c1y.getPositiveValue().toByteArray())).substring(0, 2))) {
            c1yHex = c1yHex.substring(2);
        }
        String c2Hex = c2.toString().substring(1);
        String c3Hex = c3.toString().substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("04");
        stringBuilder.append(c1xHex);
        stringBuilder.append(c1yHex);
        stringBuilder.append(c3Hex);
        stringBuilder.append(c2Hex);
        return ByteUtils.fromHexString((String)stringBuilder.toString());
    }

    static {
        if (null == Security.getProvider(PROVIDER)) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

