/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.activity.center.api.util.citic.mgm;

import cn.com.duiba.live.activity.center.api.bean.citic.mgm.MgmM2InfoBean;
import cn.com.duiba.live.activity.center.api.enums.citic.mgm.MgmM2StatusEnum;
import cn.com.duiba.live.activity.center.api.util.citic.mgm.KzxSM2Utils;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgmUtils {
    private static final Logger log = LoggerFactory.getLogger(MgmUtils.class);
    private static final String NEW_CUST_FLAG = "\u662f";

    private MgmUtils() {
    }

    public static Date calExpiredTime(Date date, int interval) {
        if (date == null) {
            return null;
        }
        DateTime dateTime = DateUtil.offsetDay((Date)date, (int)interval);
        DateTime endOfDay = DateUtil.endOfDay((Date)dateTime);
        return endOfDay.toJdkDate();
    }

    public static boolean verifyExpired(Date date, int interval) {
        if (date == null) {
            return true;
        }
        Date expiredDate = MgmUtils.calExpiredTime(date, interval);
        return new Date().after(expiredDate);
    }

    public static Integer calM2Status(MgmM2InfoBean bean, Integer m2InvalidInterval) {
        if (bean == null) {
            return null;
        }
        MgmM2StatusEnum m2Status = MgmM2StatusEnum.getByCardDesc(bean.getCardStatusDesc());
        if (m2Status == null) {
            log.warn("citic mgm, not match m2 status, bean:{}", (Object)bean);
            return MgmM2StatusEnum.UNKNOWN.getStatus();
        }
        if (MgmM2StatusEnum.FIRST_AUDIT_PASS.equals((Object)m2Status) && MgmUtils.isConsumeInvalid(bean.getCreateDate(), bean.getCardFirstPurchaseDte(), m2InvalidInterval)) {
            return MgmM2StatusEnum.INVALID.getStatus();
        }
        if (MgmM2StatusEnum.NO_NEW_CUST_FLAG_LIST.contains(m2Status.getStatus())) {
            return m2Status.getStatus();
        }
        if (!NEW_CUST_FLAG.equals(bean.getNewCustFlag())) {
            return MgmM2StatusEnum.NOT_MATCH.getStatus();
        }
        if (MgmM2StatusEnum.CONSUME.equals((Object)m2Status) && MgmUtils.isConsumeInvalid(bean.getCreateDate(), bean.getCardFirstPurchaseDte(), m2InvalidInterval)) {
            return MgmM2StatusEnum.INVALID.getStatus();
        }
        return m2Status.getStatus();
    }

    private static boolean isConsumeInvalid(Date createTime, Date consumeTime, Integer m2InvalidInterval) {
        if (createTime == null || consumeTime == null || m2InvalidInterval == null) {
            return true;
        }
        long betweenDays = DateUtil.between((Date)createTime, (Date)consumeTime, (DateUnit)DateUnit.DAY, (boolean)true);
        return betweenDays > (long)m2InvalidInterval.intValue();
    }

    public static String encode(String data, String pubKey) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return "";
        }
        try {
            byte[] decMsg = KzxSM2Utils.encrypt(pubKey, data.getBytes(StandardCharsets.UTF_8));
            return MgmUtils.bytes2hex02(decMsg);
        }
        catch (Exception e) {
            log.warn("citic mgm, encode data fail, data:{}", (Object)data, (Object)e);
            return "";
        }
    }

    public static String bytes2hex02(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        for (byte b : bytes) {
            tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = "0" + tmp;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static String decode(String encodeData, String priKey) {
        if (StringUtils.isBlank((CharSequence)encodeData)) {
            return "";
        }
        try {
            byte[] decMsg = KzxSM2Utils.decrypt(priKey, Hex.decode((String)encodeData));
            return new String(decMsg, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.warn("citic mgm, decode data fail, encodeData:{}", (Object)encodeData, (Object)e);
            return "";
        }
    }

    public static String sign(String encodeData, String priKey) {
        if (StringUtils.isBlank((CharSequence)encodeData)) {
            return "";
        }
        try {
            String digest = MgmUtils.sm3(encodeData);
            return KzxSM2Utils.sign(priKey, digest.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("citic mgm, sign encodeData fail, encodeData:{}", (Object)encodeData, (Object)e);
            return "";
        }
    }

    public static boolean verify(String encodeData, String sign, String pubKey) {
        if (StringUtils.isBlank((CharSequence)encodeData)) {
            return false;
        }
        try {
            String digest = MgmUtils.sm3(encodeData);
            return KzxSM2Utils.verify(pubKey, digest.getBytes(StandardCharsets.UTF_8), Hex.decode((String)sign));
        }
        catch (Exception e) {
            log.warn("citic mgm, verify data fail, encodeData:{}, sign:{}", new Object[]{encodeData, sign, e});
            return false;
        }
    }

    private static String sm3(String encodeData) {
        byte[] md = new byte[32];
        byte[] msg1 = encodeData.getBytes(StandardCharsets.UTF_8);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        return new String(Hex.encode((byte[])md));
    }
}

