/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.enums.guide;

import cn.com.duiba.kjy.livecenter.api.util.NumberUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum GuideNodeTypeEnum {
    RESOURCE(1, "\u8d44\u6599"),
    LOTTERY(2, "\u62bd\u5956"),
    REDPACKET(3, "\u7ea2\u5305"),
    WELFARE_RAIN(4, "\u798f\u5229\u96e8"),
    BOOM_APPOINTMENT(5, "\u7206\u6b3e\u9884\u7ea6");

    Integer nodeType;
    String desc;
    private static final Map<Integer, GuideNodeTypeEnum> ENUM_MAP;
    public static final Set<Integer> RESOURCE_TYPE;

    private GuideNodeTypeEnum(Integer nodeType, String desc) {
        this.nodeType = nodeType;
        this.desc = desc;
    }

    public static GuideNodeTypeEnum getByType(Integer nodeType) {
        return ENUM_MAP.get(nodeType);
    }

    public static boolean isResource(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return RESOURCE_TYPE.contains(type);
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<Integer, GuideNodeTypeEnum>();
        RESOURCE_TYPE = new HashSet<Integer>();
        for (GuideNodeTypeEnum tmp : GuideNodeTypeEnum.values()) {
            ENUM_MAP.put(tmp.getNodeType(), tmp);
        }
        RESOURCE_TYPE.add(RESOURCE.getNodeType());
        RESOURCE_TYPE.add(BOOM_APPOINTMENT.getNodeType());
    }
}

