package cn.com.duiba.live.activity.center.api.dto.fission;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
* 直播间营销活动
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LiveMarketActivityDto implements Serializable {

    private static final long serialVersionUID = -2492514671227409501L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型:1-免费领
     * @see cn.com.duiba.live.activity.center.api.enums.fission.FissionActivityTypeEnum
     */
    private Integer activityType;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}

